<?php

function getBankAccountData($bankCode, $accountNumber) {
    $url = "https://api-rekening.lfourr.com/getBankAccount?bankCode=$bankCode&accountNumber=$accountNumber";
    $response = file_get_contents($url);

    if ($response === FALSE) {
        return ["error" => "Gagal mengambil data dari sumber."];
    } else {
        $data = json_decode($response, true);

        // Periksa apakah penguraian JSON berhasil
        if ($data === NULL || !isset($data['data']['accountname'])) {
            return ["error" => "Gagal mendapatkan nama akun."];
        } else {
            // Hilangkan "GOPAY" dan "DANA Top Up" dari accountname
            $accountName = $data['data']['accountname'];
            $accountName = str_replace(["GOPAY", "DANA Top Up", "SHOPEEPAY/"], "", $accountName);
            
            // Hapus spasi berlebih di awal dan akhir string
            $accountName = trim($accountName);

            return $accountName;
        }
    }
}

?>